(* XSPELL.PAS - Copyright (c) 1995-1997, Eminent Domain Software *)

unit XSpell;
  {-Delphi Spell Checking Expert}
interface
uses SysUtils, ExptIntf, ToolIntf, WinProcs, WinTypes, ExtCtrls, Dialogs,
     Messages, Classes, Controls, StdCtrls;

{begin -------------- XSpell Defines ------------------}

   (* Remove the period from the define below to force Delphi to load     *)
   (* the XSpell.DLL when Delphi loads.  This will increase the speed     *)
   (* in which XSpell loads, but will take up more memory during Delphi's *)
   (* normal operations.                                                  *)

{.$DEFINE LoadDLLAtStartUp}

   (* By default, the XSpell.DLL stays in memory after it is first run.   *)
   (* Disable the following define if you prefer that XSpell unload       *)
   (* itself after it is finished spell checking.                         *)

{.$DEFINE StayResident}

(* NOTE: Changing either of these defines will require you to recompile   *)
(*       your Component Palette.                                          *)

{end ---------------- XSpell Defines ------------------}

type
  TXSpellExpert = class (TIExpert)
  private
    {Private Declarations}
    FOnTop: Boolean;
    FTimer: TTimer;
    XHandle: THandle;
    XCall: TFarProc;
    procedure LoadDLL;
      {-loads the appropriate DLL into memory}
    procedure FreeDLL;
      {-unloads the XSpell DLL from memory}
  public
    {Public Declarations}
    constructor Create;
    destructor Destroy; override;
    function GetStyle: TExpertStyle; override;
    function GetIDString: string; override;
    function GetName: string; override;
  {$IFDEF Win32}
    function GetAuthor: string; override;
    function GetPage: string; override;
  {$ENDIF}
    function GetGlyph: HICON; override;
    function GetComment: string; override;
    function GetMenuText: string; override;
    function GetState: TExpertState; override;
    procedure Execute; override;
  end;  { TXSpellExPert }

 procedure Register;
   {-register procedure for XSpell}

implementation

type
  TXSpellProc = procedure (ToolsPtr: TIToolServices);

procedure TXSpellExpert.LoadDLL;
  {-loads the appropriate DLL into memory}
begin
  if XHandle = 0 then
  begin
{$IFDEF Win32}
    XHandle := LoadLibrary ('XSPELL32.DLL');
{$ELSE}
    XHandle := LoadLibrary ('XSPELL16.DLL');
{$ENDIF}
    XCall := GetProcAddress (XHandle, 'XSPELLCHECK');
  end;  { if... }
end;  { TXSpellExpert.LoadDLL }

procedure TXSpellExpert.FreeDLL;
  {-unloads the XSpell DLL from memory}
begin
  if XHandle <> 0 then
  begin
    FreeLibrary (XHandle);
    XHandle := 0;
  end;  { if... }
end;  { TXSpellExpert.FreeDLL }

constructor TXSpellExpert.Create;
begin
  inherited Create;
  XHandle := 0;
{$IFDEF LoadDLLAtStartUp}
  LoadDLL;
{$ENDIF}
end;  { TXSpellExpert.Create }

function TXSpellExpert.GetStyle: TExpertStyle;
begin
  Result := esStandard;
end; { TXSpellExpert.GetStyle }

function TXSpellExpert.GetIDString: string;
begin
  Result := 'XSpell.Speller';
end; { TXSpellExpert.GetIDString }

function TXSpellExpert.GetName: string;
begin
  Result := 'XSpell Checker for Delphi';
end; { TXSpellExpert.GetIDString }

{$IFDEF Win32}
function TXSpellExpert.GetAuthor: string;
begin
  Result := 'Eminent Domain Software';
end; { TXSpellExpert.GetAuthor }

function TXSpellExpert.GetPage: string;
begin
  Result := '';
end; { TXSpellExpert.GetPage }
{$ENDIF}

function TXSpellExpert.GetGlyph: HICON;
begin
  Result := 0;
end; { TXSpellExpert.Glyph }

function TXSpellExpert.GetComment: string;
begin
  Result := '';
end; { TXSpellExpert.Comment }

function TXSpellExpert.GetMenuText: string;
begin
  Result := '&XSpell Checker';
end; { TXSpellExpert.GetMenuText }

function TXSpellExpert.GetState: TExpertState;
begin
  Result := [esEnabled];
  if FOnTop then
    Include(Result, esChecked);
end; { TXSpellExpert.GetStyle }

procedure TXSpellExpert.Execute;
begin
  if (ToolServices <> nil) then
  begin
    if XHandle = 0 then
      LoadDLL;
    if XCall <> nil then
      TXSpellProc (XCall)(ToolServices)
    else
      MessageDlg ('XSPELLCheck function not in DLL.', mtError, [mbOk], 0);
{$IFNDEF StayResident}
    FreeDLL;
{$ENDIF}
  end;  { if... }
end; { TXSpellExpert.Execute}

destructor TXSpellExpert.Destroy;
begin
  FreeDLL;
  inherited Destroy;
end; { TXSpellExpert.Destroy }

procedure Register;
  {-register procedure for XSpell}
begin
  RegisterLibraryExpert (TXSpellExpert.Create);
end; { Register }

end.  { XSpell }
